% Initialize Variables
  
    fname='output';
    ss=8000; % arbitrary starting point
    Lm=40;
    Rm=10;%10
    nfft=2048; % power of 2 between 512 and 4096
    ceplm=30;
    istart=1;

% read in speech/audio signal into curr_file; sampling rate is fs 
    [curr_file,fs]=audioread('_Segment_17_CHN.wav');
    FS=num2str(fs); 
    L=round(Lm*fs/1000);
    R=round(Rm*fs/1000);
    win=hamming(L);
    cepl=round(ceplm*fs/1000);    

    [b,BNmag,cell_lifter,stitle,c]=cepstral_liftering_speech(curr_file,ss,win,fs,L,nfft,cepl,ccal,fname);
   
    % plot lifters
    figure;
    for i=1:5
        A = cell2mat(cell_lifter(i));
        plot(A,'-r');
        hold on;
    end;
    hold off; 
    
    
    
    
    
    
% plot real cepstrum for frame of speech on graphics Panel 2
    figure;
    plot(0:cepl-1,c(cepl:-1:1),'b','LineWidth',2);
    xpp=['Quefrency in Samples; fs=',num2str(fs),' samples/second'];
    xlabel(xpp),ylabel('Cepstral Level');grid on;axis tight; 
    legend('real cepstrum of current frame');
    
% perform low quefrency liftering of cepstrum and plot resulting smoothed
% log magnitude spectrums for range of liftering quefrencies; plot results
  %  fg=figure;
  %  plot_cepstral_liftering(fg,titleBox1,stitle,fs,nfft,BNmag,cell_lifter);
   
